	function [Z1, P1, Z2, P2, Att] = SYM_WDF(ncoe,idelay,nbands,edge,des,wt)
	
	%	function	[Z1, P1, Z2, P2, Att] = SYM_WDF(ncoe,idelay,nbands,edge,des,wt)
	% Algorithm for designing wave lattice filters (parallel connection of two
	% stable allpass filters) having several (max 6) passband and stopband
	% regions and arbitrary weightings in these regions.
	% Filters proving an arbitrary non-integer delay, approximately linear-phase
	% Hilbert transformers and filters with transfer function of the form 
	% H(z) = [z-M + A(z)]/2 with A(z) being an allpass filter (approximately
	% linear allpass filters) can be also designed straightforward.
	% In future phase equalizers (this part will be added later) can also be
	% designed.
	% Att are the ripples or attenuations in the bands.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Tapio Saramaki, 2018-03-10
	% 	Modified by: 	LW, 2019-03-04
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	tapio.saramaki@tut.fi
	
	
	% Main fuction is remezall.m and it use these subfuctions (see diagram):
	% <---------------------------------------------------------------<< DH <<<
	% SYM_WDF.m -> linremez.m -> newgrid.m
	%                          -> iextnew.m
	%                          -> forcing.m -> forcehelp.m -> phas.m
	%                          -> phas.m
	%                          -> removeiext.m
	%            -> factors.m *)
	% <---------------------------------------------------------------<< DH <<<
	% *) only function factors.m needs signal processing toolbox
	
	% Parametres: SYM_WDF(ncoe,idelay,nbands,edge,des,wt,ngrid)
	% ncoe    filter order, 3-21 ...70 higher the order harder to find solution
	% idelay  delay, only needed for those approximately linear allpass filter
	%         designs or when needed to force one or more poles to origin.
	% nbands  number of passbands and stopbands, 1 - 6
	% edge    band edges, two values for each band, [0 0.1 0.12 0.5]
	% des     desired phase difference (0 = passband -1 = stopband), [0 -1 0]
	% wt      weight values for band, one value per band, [0.1 0.01] or use 
	%         weight vector and give one value for each grid point,  
	% ngrid   number of grid points, 1000 is good starting value 
	
	% <--- edited Apr-30-2008 with MATLAB R2006a ---------------------<< DH <<<
	
	
	edge = edge/(2*pi); des = des/pi; ngrid = 1000; % Use normalized internal variables
	
	linremez(ncoe,idelay,nbands,edge,des,wt,ngrid);
	[Z1,P1, Z2, P2, Att] = factors(ncoe,idelay,nbands,edge,des);
	% ========================================================	

	
